VERSION 5.00
Object = "{86CF1D34-0C5F-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCOMCT2.OCX"
Begin VB.Form frmTrace 
   AutoRedraw      =   -1  'True
   Caption         =   "Pin Logic Trace"
   ClientHeight    =   5385
   ClientLeft      =   1245
   ClientTop       =   2175
   ClientWidth     =   10110
   BeginProperty Font 
      Name            =   "Tahoma"
      Size            =   8.25
      Charset         =   0
      Weight          =   400
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   HelpContextID   =   1100
   Icon            =   "frmTrace.frx":0000
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   MDIChild        =   -1  'True
   ScaleHeight     =   5385
   ScaleWidth      =   10110
   Begin VB.Frame fraControls 
      Height          =   4320
      Left            =   9195
      TabIndex        =   12
      Top             =   0
      Width           =   870
      Begin VB.CommandButton cmdReset 
         Caption         =   "Reset"
         Height          =   330
         HelpContextID   =   1100
         Left            =   75
         TabIndex        =   5
         ToolTipText     =   "Reset the trace display settings to their default values"
         Top             =   3435
         Width           =   720
      End
      Begin VB.CheckBox chkOption 
         Caption         =   "GND"
         Height          =   210
         HelpContextID   =   1100
         Index           =   1
         Left            =   90
         TabIndex        =   7
         ToolTipText     =   "Include in the GND logic level"
         Top             =   4035
         Width           =   690
      End
      Begin VB.CheckBox chkOption 
         Caption         =   "Diff"
         Height          =   240
         HelpContextID   =   1100
         Index           =   0
         Left            =   90
         TabIndex        =   6
         ToolTipText     =   "Display the expected result as well as the actual one"
         Top             =   3780
         Width           =   705
      End
      Begin VB.VScrollBar VScroll 
         Height          =   840
         HelpContextID   =   1100
         Left            =   75
         Min             =   1
         TabIndex        =   4
         Top             =   2550
         Value           =   1
         Width           =   225
      End
      Begin MSComCtl2.UpDown UpDown 
         Height          =   300
         HelpContextID   =   1100
         Index           =   2
         Left            =   540
         TabIndex        =   2
         ToolTipText     =   "Move the entire trace display up or down"
         Top             =   1455
         Width           =   240
         _ExtentX        =   423
         _ExtentY        =   529
         _Version        =   393216
         Value           =   2
         BuddyControl    =   "lblYAdjust"
         BuddyDispid     =   196615
         OrigLeft        =   660
         OrigTop         =   1785
         OrigRight       =   900
         OrigBottom      =   2100
         Increment       =   25
         Max             =   300
         Min             =   -300
         SyncBuddy       =   -1  'True
         BuddyProperty   =   65537
         Enabled         =   -1  'True
      End
      Begin MSComCtl2.UpDown UpDown 
         Height          =   300
         HelpContextID   =   1100
         Index           =   3
         Left            =   540
         TabIndex        =   3
         ToolTipText     =   "Change the size of each trace"
         Top             =   2010
         Width           =   240
         _ExtentX        =   423
         _ExtentY        =   529
         _Version        =   393216
         Value           =   250
         BuddyControl    =   "lblTraceSize"
         BuddyDispid     =   196617
         OrigLeft        =   255
         OrigTop         =   2730
         OrigRight       =   495
         OrigBottom      =   3240
         Increment       =   50
         Max             =   1000
         Min             =   100
         SyncBuddy       =   -1  'True
         BuddyProperty   =   65537
         Enabled         =   -1  'True
      End
      Begin MSComCtl2.UpDown UpDown 
         Height          =   300
         HelpContextID   =   1100
         Index           =   1
         Left            =   540
         TabIndex        =   1
         ToolTipText     =   "Change the spacing between each trace"
         Top             =   885
         Width           =   240
         _ExtentX        =   423
         _ExtentY        =   529
         _Version        =   393216
         Value           =   1
         BuddyControl    =   "lblYSpace"
         BuddyDispid     =   196619
         OrigLeft        =   540
         OrigTop         =   990
         OrigRight       =   780
         OrigBottom      =   1290
         Increment       =   10
         Max             =   250
         Min             =   -250
         SyncBuddy       =   -1  'True
         BuddyProperty   =   0
         Enabled         =   -1  'True
      End
      Begin MSComCtl2.UpDown UpDown 
         Height          =   300
         HelpContextID   =   1100
         Index           =   0
         Left            =   540
         TabIndex        =   0
         ToolTipText     =   "Change the grid size"
         Top             =   330
         Width           =   240
         _ExtentX        =   423
         _ExtentY        =   529
         _Version        =   393216
         BuddyControl    =   "lblGridSize"
         BuddyDispid     =   196622
         OrigLeft        =   420
         OrigTop         =   315
         OrigRight       =   660
         OrigBottom      =   645
         Max             =   5
         SyncBuddy       =   -1  'True
         BuddyProperty   =   65537
         Enabled         =   -1  'True
      End
      Begin VB.Label Label5 
         AutoSize        =   -1  'True
         BackStyle       =   0  'Transparent
         Caption         =   "Y-Scroll:"
         Height          =   195
         Left            =   45
         TabIndex        =   22
         Top             =   2340
         Width           =   585
      End
      Begin VB.Label lblYAdjust 
         Alignment       =   2  'Center
         BackStyle       =   0  'Transparent
         BorderStyle     =   1  'Fixed Single
         Caption         =   "0"
         Height          =   300
         Left            =   90
         TabIndex        =   20
         Top             =   1470
         Width           =   435
      End
      Begin VB.Label Label4 
         Caption         =   "Y-Adjust:"
         Height          =   195
         Left            =   45
         TabIndex        =   19
         Top             =   1230
         Width           =   675
      End
      Begin VB.Label lblTraceSize 
         Alignment       =   2  'Center
         BackStyle       =   0  'Transparent
         BorderStyle     =   1  'Fixed Single
         Caption         =   "250"
         Height          =   300
         Left            =   90
         TabIndex        =   18
         Top             =   2010
         Width           =   435
      End
      Begin VB.Label Label3 
         AutoSize        =   -1  'True
         BackStyle       =   0  'Transparent
         Caption         =   "Zoom:"
         Height          =   195
         Left            =   45
         TabIndex        =   17
         Top             =   1800
         Width           =   450
      End
      Begin VB.Label lblYSpace 
         Alignment       =   2  'Center
         BackStyle       =   0  'Transparent
         BorderStyle     =   1  'Fixed Single
         Caption         =   "150"
         Height          =   300
         Left            =   90
         TabIndex        =   16
         Top             =   900
         Width           =   435
      End
      Begin VB.Label Label1 
         AutoSize        =   -1  'True
         BackStyle       =   0  'Transparent
         Caption         =   "Y-Space:"
         Height          =   195
         Left            =   45
         TabIndex        =   15
         Top             =   660
         Width           =   645
      End
      Begin VB.Label Label2 
         BackStyle       =   0  'Transparent
         Caption         =   "Grid Size:"
         Height          =   180
         Left            =   45
         TabIndex        =   14
         Top             =   120
         Width           =   690
      End
      Begin VB.Label lblGridSize 
         Alignment       =   2  'Center
         BackStyle       =   0  'Transparent
         BorderStyle     =   1  'Fixed Single
         Caption         =   "2"
         Height          =   300
         Left            =   90
         TabIndex        =   13
         Top             =   345
         Width           =   435
      End
   End
   Begin VB.PictureBox picSep 
      BorderStyle     =   0  'None
      Height          =   4935
      Left            =   1005
      MousePointer    =   9  'Size W E
      ScaleHeight     =   4935
      ScaleWidth      =   75
      TabIndex        =   11
      Top             =   90
      Width           =   75
   End
   Begin VB.HScrollBar HScroll 
      Height          =   225
      HelpContextID   =   1100
      LargeChange     =   10
      Left            =   1095
      TabIndex        =   8
      Top             =   5040
      Width           =   8040
   End
   Begin VB.PictureBox picKey 
      AutoRedraw      =   -1  'True
      Height          =   4935
      HelpContextID   =   1100
      Left            =   15
      ScaleHeight     =   4875
      ScaleWidth      =   915
      TabIndex        =   10
      Top             =   90
      Width           =   975
   End
   Begin VB.PictureBox picTrace 
      AutoRedraw      =   -1  'True
      Height          =   4935
      HelpContextID   =   1100
      Left            =   1110
      ScaleHeight     =   4875
      ScaleWidth      =   7950
      TabIndex        =   9
      Top             =   90
      Width           =   8010
   End
   Begin VB.Label lblStart 
      Alignment       =   1  'Right Justify
      BackStyle       =   0  'Transparent
      Height          =   210
      Left            =   15
      TabIndex        =   21
      ToolTipText     =   "Shows the number of the first displayed sample"
      Top             =   5040
      Width           =   975
   End
End
Attribute VB_Name = "frmTrace"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private mbReset                                 As Boolean
Private mbMouseDown                             As Boolean
Private mbKeyDrawn                              As Boolean
Private mbytSamples()                           As Byte
Private mnSamples                               As Integer

Private Const Module_Name                       As String = "frmTrace"
Public Function AddEntry(sBinaryData As String, bRealTimePlot As Boolean, sExpectedData As String) As Boolean

    
    Dim nNumPins                        As Integer
    Dim nPin                            As Integer
   
    On Error GoTo ErrorHandler
    
    
    nNumPins = gtypModel.NumPins
    mnSamples = mnSamples + 1
        
    If UBound(mbytSamples, 3) < mnSamples Then
        ReDim Preserve mbytSamples(MAX_PINS, 2, mnSamples + 1000)
    End If
    
    For nPin = 1 To nNumPins
        mbytSamples(nPin, 0, mnSamples) = Val(Mid$(sBinaryData, nPin, 1))
        mbytSamples(nPin, 1, mnSamples) = gtypModel.Pin(nPin).Usage ' Stores the current usage of the pin (this can change for I/O pins)
        mbytSamples(nPin, 2, mnSamples) = Val(Mid$(sExpectedData, nPin, 1))
    Next nPin
    
    If bRealTimePlot = True Then
        Call RedrawGrid(UpDown(0).Value, UpDown(1).Value, UpDown(3).Value, UpDown(2).Value, HScroll.Value, VScroll.Value, True)
    End If
    
    HScroll.Max = mnSamples + 1
    
    AddEntry = True
    Exit Function
    
ErrorHandler:
    If Err = 9 Then
        Resume Next
    Else
        AddEntry = False ' Out of memory
    End If
    
End Function

Private Sub RedrawData(nYSpace As Integer, nTraceSize As Integer, nYAdjust As Integer, nStartSample As Integer, nStartPin As Integer, bShowEnd As Boolean)
'
' Replots the data on the display

    Dim bOptionDiff             As Boolean
    Dim bOptionGND              As Boolean
    Dim nSample                 As Integer
    Dim nPin                    As Integer
    Dim nPreviousSample(1)      As Integer
    Dim nPinUsage               As Integer
    Dim z                       As Integer
    Dim X                       As Long
    Dim Y                       As Long
    Dim lColor                  As Long
    
    
    On Error GoTo ErrorHandler
    
    If mbKeyDrawn = False Then
        picKey.Cls
    End If
    '
    ' Do this now - quicker than testing the control value all the time later !
    bOptionGND = chkOption(1).Value
    bOptionDiff = chkOption(0).Value
    
    If bShowEnd = True Then
        nStartSample = mnSamples - (picTrace.Width / nTraceSize)
        If nStartSample < 0 Then
            nStartSample = 0
        End If
    End If
    
    Y = 500 + nYAdjust ' nYSpace
    
    lblStart.Caption = Format$(nStartSample)
    
    With gtypModel
        If .NumPins Then
            For nPin = nStartPin To .NumPins
                X = 0
                nPreviousSample(0) = 0
                nPreviousSample(1) = 0
                nPinUsage = .Pin(nPin).Usage
                If nPinUsage <> 3 And nPinUsage <> 4 And nPinUsage <> 5 Then
                    ' We can plot this pin (not a voltage pin or a N/C pin)
                    If mbKeyDrawn = False Then
                        picKey.CurrentX = 0
                        picKey.CurrentY = Y - (nTraceSize / 2)
                        picKey.Print .Pin(nPin).Tag
                        
                        picKey.CurrentX = picKey.Width - 300
                        picKey.CurrentY = Y - (nTraceSize / 2)
                        picKey.Print nPin
                    End If
                    
                    If mnSamples >= 0 Then
                        If bOptionGND Then
                            ' Draw in the base line
                            ' Do it now so we can 'plot' over the top of it
                            picTrace.DrawStyle = vbDashDotDot
                            picTrace.Line (0, Y)-(picTrace.Width, Y), glColors(14)
                        End If
                                            
                        For nSample = nStartSample To mnSamples
                            If nSample = nStartSample Then
                                ' Were not plotting from the beginning
                                nPreviousSample(0) = mbytSamples(nPin, 0, nSample)
                                nPreviousSample(1) = mbytSamples(nPin, 2, nSample)
                            End If
                                
                            ' Set the trace colour to use
                            picTrace.DrawStyle = vbSolid
                            Select Case mbytSamples(nPin, 1, nSample)
                            Case 0, 20 ' Pin IS or Currently is an Input (from IC to PIC)
                                lColor = glColors(10)
                                'bOptionDiff(1) = False ' Prevent drawing expected trace for this pin
                                'bOptionDiff(1) = bOptionDiff(0)
                                
                            Case Else
                                ' Pin IS or Currently is an Output (from PIC to IC)
                                lColor = glColors(12)
                                'bOptionDiff(1) = bOptionDiff(0)
                                
                            End Select
                            
                            For z = 0 To Abs(bOptionDiff)
                                '
                                Select Case z
                                Case 0 ' Drawing the actual sample value
                                    If mbytSamples(nPin, 0, nSample) <> nPreviousSample(0) Then
                                        ' Logic level changed
                                        ' Draw in the transition
                                        If mbytSamples(nPin, 0, nSample) = 0 Then
                                            ' Logic 0
                                            picTrace.Line (X, Y - (nPreviousSample(0) * nTraceSize))-(X, Y), lColor
                                        Else
                                            ' Logic 1
                                            picTrace.Line (X, Y - (nPreviousSample(0) * nTraceSize))-(X, Y - nTraceSize), lColor
                                        End If
                                        nPreviousSample(0) = mbytSamples(nPin, 0, nSample)
                                    End If
                                    picTrace.Line (X, Y - (nPreviousSample(0) * nTraceSize))-(X + nTraceSize, Y - (nPreviousSample(0) * nTraceSize)), lColor
                                
                                Case Else
                                    ' Were drawing in the expected value
                                    lColor = glColors(13)
                                    picTrace.DrawStyle = vbDot
                                    
                                    If mbytSamples(nPin, 2, nSample) <> nPreviousSample(1) Then
                                        ' Sample is not what was expected
                                        ' Draw in the transition (vertical)
                                        If mbytSamples(nPin, 2, nSample) = 0 Then
                                            ' Logic 0
                                            picTrace.Line (X, Y - (nPreviousSample(1) * nTraceSize))-(X, Y), lColor
                                        Else
                                            ' Logic 1
                                            picTrace.Line (X, Y - (nPreviousSample(1) * nTraceSize))-(X, Y - nTraceSize), lColor
                                        End If
                                        nPreviousSample(1) = mbytSamples(nPin, 2, nSample)
                                    End If
                                    picTrace.Line (X, Y - (nPreviousSample(1) * nTraceSize))-(X + nTraceSize, Y - (nPreviousSample(1) * nTraceSize)), lColor
                                                            
                                End Select
                                
                            Next z
                            
                            X = X + nTraceSize
                            If X >= picTrace.Width Then
                                ' We've run off the end of the display
                                
                                Exit For
                            End If
                            
                        Next nSample
                    End If ' mnSamples > 0
                    Y = Y + (nTraceSize + 100 + nYSpace) ' Calculate start position for next trace line
                End If ' Pin usage
            Next nPin
        End If ' .numPins > 0
    End With
    
    mbKeyDrawn = True
    
    Exit Sub
    
ErrorHandler:
    Resume Next
End Sub

Private Sub RedrawGrid(nGridSize As Integer, nYSpace As Integer, nTraceSize As Integer, nYAdjust As Integer, nStartSample As Integer, nStartPin As Integer, bShowEnd As Boolean)
    Dim X                               As Long
    Dim x1                              As Long
    Dim Y                               As Long
    Dim y1                              As Long
    
    Const PROC_NAME                     As String = "RedrawGrid"
    
    On Error GoTo ErrorHandler
    
    If mbReset = False Then
        'Screen.MousePointer = 11
        'DoEvents
        
        x1 = picTrace.Width
        y1 = picTrace.Height
        
        picTrace.Cls
        picTrace.Visible = False
        picTrace.DrawStyle = vbSolid
        
            
        If nGridSize > 0 Then
            For X = 0 To x1 Step 250 * nGridSize
                picTrace.Line (X, 0)-(X, y1), glColors(11)
                For Y = 0 To y1 Step 250 * nGridSize
                    picTrace.Line (0, Y)-(x1, Y), glColors(11)
                Next Y
            Next X
        End If
            
        Call RedrawData(nYSpace, nTraceSize, nYAdjust, nStartSample, nStartPin, bShowEnd)
        
        picTrace.Visible = True
        'Screen.MousePointer = 0
    End If
    
    Exit Sub
    
ErrorHandler:
    ErrorRoutine Module_Name, PROC_NAME, Err
End Sub


Public Sub RefreshDetails(nStartSample As Integer)
    
    HScroll.Max = mnSamples
    HScroll.Value = nStartSample
    
    If gtypModel.NumPins > 2 Then
        VScroll.Max = gtypModel.NumPins - 1
    End If
    VScroll.Value = 1

    Call RedrawGrid(UpDown(0).Value, UpDown(1).Value, UpDown(3).Value, UpDown(2).Value, HScroll.Value, VScroll.Value, False)

End Sub

Public Sub Reset()

    mnSamples = -1
    Erase mbytSamples
    mbKeyDrawn = False
    
End Sub

Private Sub chkOption_Click(Index As Integer)

    SaveSetting App.Title, "LogicTrace", "OptionSetting" & Format$(Index), chkOption(Index).Value
    
   
    'If chkOption(0).Value Then
    '    ' Set minimum zoom factor so dotted line can be seen
    '    UpDown(3).Value = 400
    'End If
    
    Call RedrawGrid(UpDown(0).Value, UpDown(1).Value, UpDown(3).Value, UpDown(2).Value, HScroll.Value, VScroll.Value, False)
    
End Sub

Private Sub cmdReset_Click()
    Dim F                       As Integer
    
    
    mbReset = True
    
    UpDown(0).Value = 2 ' Grid size
    UpDown(1).Value = 150
    UpDown(2).Value = 0
    UpDown(3).Value = 250
    HScroll.Value = 0
    VScroll.Value = 1
    chkOption(0).Value = 0
    chkOption(1).Value = 0
    
    For F = 0 To UpDown.Count - 1
        SaveSetting App.Title, "LogicTrace", "Setting" & Format$(F), UpDown(F).Value
    Next F
    For F = 0 To chkOption.Count - 1
        SaveSetting App.Title, "LogicTrace", "OptionSetting" & Format$(F), chkOption(F).Value
    Next F
    
    mbReset = False
    Call RedrawGrid(UpDown(0).Value, UpDown(1).Value, UpDown(3).Value, UpDown(2).Value, HScroll.Value, VScroll.Value, False)
    
End Sub

Private Sub Form_Load()

    Dim F                               As Integer
    Dim G                               As Integer
        
    Const PROC_NAME                     As String = "Form_Load"
    
    On Error GoTo ErrorHandler
        
    mnSamples = -1
    gbFormLoaded(0) = True
    mbReset = True
    With picTrace
        .BackColor = glColors(9)
        .FillColor = glColors(10)
        .FillStyle = vbFSSolid
    End With
    
    With picSep
        .ForeColor = Me.BackColor
    End With
        
    ' We do this the long way so we can specify some defaulst
    UpDown(0) = GetSetting(App.Title, "LogicTrace", "Setting0", 2)
    UpDown(1) = GetSetting(App.Title, "LogicTrace", "Setting1", 150)
    UpDown(2) = GetSetting(App.Title, "LogicTrace", "Setting2", 0)
    UpDown(3) = GetSetting(App.Title, "LogicTrace", "Setting3", 250)
    
    For F = 0 To chkOption.Count - 1
        chkOption(F).Value = Val(GetSetting(App.Title, "LogicTrace", "OptionSetting" & Format$(F), "0"))
    Next F
    
    HScroll.Max = mnSamples + 1
    HScroll.Value = 0
    
    VScroll.Max = gtypModel.NumPins
    VScroll.Value = 1
    
    
    RecoverFormLoadPosition Me, False
    Call RedrawGrid(UpDown(0).Value, UpDown(1).Value, UpDown(3).Value, UpDown(2).Value, HScroll.Value, VScroll.Value, False)
    
    mbReset = False
    
    Exit Sub
    
ErrorHandler:
    ErrorRoutine Module_Name, PROC_NAME, Err
End Sub






Private Sub Form_QueryUnload(Cancel As Integer, UnloadMode As Integer)

    ' Save the forms current position
    If Me.WindowState <> vbMinimized Then
        SaveSetting App.Title, "FormPositions", Me.Name, Format$(Me.Width) & "," & Format$(Me.Height) & "," & Format$(Me.Top) & "," & Format$(Me.Left)
    End If
    
    gbFormLoaded(0) = False
    Unload Me
    
End Sub


Private Sub Form_Resize()

    Dim lWidth                      As Long
    
    
    If Me.Height < 4905 Then
        Me.Height = 4905
    End If
    If Me.Width < 3540 Then
        Me.Width = 3540
    End If
        
    ' Set the width of the 'Key' picture control
    fraControls.Left = (Me.Width - fraControls.Width) - 100
    
    lWidth = picSep.Left
    Select Case lWidth
    Case Is < 100
        lWidth = 100
        picSep.Left = lWidth
    
    Case Is > 2000
        lWidth = 2000
        picSep.Left = lWidth
    
    End Select
    
    With picKey
        .Width = lWidth - 50
        .Height = Me.Height - 700
        
        lblStart.Top = .Height + .Top
        lblStart.Width = .Width
    End With
    
    With picTrace
        .Left = picSep.Left + picSep.Width
        lWidth = fraControls.Left - .Left
        If lWidth < 1000 Then
            lWidth = 1000
        End If
        .Width = lWidth
        .Height = Me.Height - 700
    End With
    
    With HScroll
        .Top = picTrace.Top + picTrace.Height '+ 25
        .Left = picTrace.Left
        .Width = picTrace.Width
    End With
    
    Call RedrawGrid(UpDown(0).Value, UpDown(1).Value, UpDown(3).Value, UpDown(2).Value, HScroll.Value, VScroll.Value, False)
    
End Sub


Private Sub HScroll_Change()

    Call RedrawGrid(UpDown(0).Value, UpDown(1).Value, UpDown(3).Value, UpDown(2).Value, HScroll.Value, VScroll.Value, False)
    
End Sub

Private Sub picSep_MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)

    If Button = 1 Then
        mbMouseDown = True
    End If
    
End Sub

Private Sub picSep_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)

    If mbMouseDown = True Then
        picSep.Left = picSep.Left + X
        DoEvents
    End If
End Sub

Private Sub picSep_MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single)

    mbMouseDown = False
    
    picSep.Left = picSep.Left + X
    
    Call Form_Resize
    
End Sub




Private Sub UpDown_Change(Index As Integer)
    
    
    SaveSetting App.Title, "LogicTrace", "Setting" & Format$(Index), UpDown(Index).Value
    
    
    Call RedrawGrid(UpDown(0).Value, UpDown(1).Value, UpDown(3).Value, UpDown(2).Value, HScroll.Value, VScroll.Value, False)
    
End Sub


Private Sub VScroll_Change()
    
    Call RedrawGrid(UpDown(0).Value, UpDown(1).Value, UpDown(3).Value, UpDown(2).Value, HScroll.Value, VScroll.Value, False)

End Sub


