VERSION 5.00
Begin VB.Form frmICView 
   AutoRedraw      =   -1  'True
   BorderStyle     =   1  'Fixed Single
   Caption         =   "IC Package View"
   ClientHeight    =   6375
   ClientLeft      =   5415
   ClientTop       =   2250
   ClientWidth     =   3270
   BeginProperty Font 
      Name            =   "Tahoma"
      Size            =   8.25
      Charset         =   0
      Weight          =   400
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   HelpContextID   =   200
   Icon            =   "frmICView.frx":0000
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   MaxButton       =   0   'False
   MDIChild        =   -1  'True
   MinButton       =   0   'False
   ScaleHeight     =   6375
   ScaleWidth      =   3270
   Begin VB.Label lblTag 
      Appearance      =   0  'Flat
      BackColor       =   &H80000005&
      BackStyle       =   0  'Transparent
      Caption         =   "Label1"
      ForeColor       =   &H80000008&
      Height          =   255
      Index           =   0
      Left            =   885
      TabIndex        =   2
      Top             =   345
      Width           =   660
   End
   Begin VB.Label lblDirection 
      Alignment       =   2  'Center
      Appearance      =   0  'Flat
      BackColor       =   &H80000005&
      BackStyle       =   0  'Transparent
      BorderStyle     =   1  'Fixed Single
      BeginProperty Font 
         Name            =   "Tahoma"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H80000008&
      Height          =   270
      Index           =   0
      Left            =   75
      TabIndex        =   1
      Top             =   330
      Width           =   675
   End
   Begin VB.Shape shpIC 
      BorderWidth     =   10
      Height          =   645
      Left            =   810
      Top             =   150
      Width           =   1515
   End
   Begin VB.Label lblPin 
      Alignment       =   2  'Center
      Appearance      =   0  'Flat
      BackColor       =   &H00C0C0C0&
      BorderStyle     =   1  'Fixed Single
      ForeColor       =   &H80000008&
      Height          =   270
      Index           =   0
      Left            =   75
      TabIndex        =   0
      Top             =   330
      Width           =   675
   End
   Begin VB.Shape Shape2 
      FillStyle       =   0  'Solid
      Height          =   105
      Left            =   1275
      Top             =   225
      Width           =   495
   End
End
Attribute VB_Name = "frmICView"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private mnPins                                  As Integer
Private mnPinSelected                           As Integer

Private Const Module_Name                       As String = "frmICView"

Public Sub PackagePins()

    ' Here, we configure the IC graphic display.
    ' Resize the graphic size and add the correct
    ' number of pins (top and bottom)

    Dim nPinsPerSide                    As Integer
    Dim F                               As Integer
    Dim nPins                           As Integer
    Dim lVerticalPosition               As Long
    Dim lLeftPosition                   As Long
    Dim lTagLeftPosition                As Long
    Dim sTemp                           As String
    
    Const PROC_NAME                     As String = "PackagePins"
    
    On Error GoTo ErrorHandler
    

    nPins = gtypModel.NumPins
    
    nPinsPerSide = nPins / 2
    
    shpIC.Height = 445 + (350 * nPinsPerSide)
    
    '
    ' Remove any old PINS
    For F = lblPin.Count - 1 To 1 Step -1
        Unload lblTag(F)
        Unload lblPin(F)
        Unload lblDirection(F)
    Next F
    
    '
    ' Now add in the new pins
    lVerticalPosition = 20
    For F = 0 To nPins - 1
        If F > 0 Then
            Load lblPin(F)
            Load lblTag(F)
            Load lblDirection(F)
        End If
        
        If F = nPinsPerSide Then
            ' Moved from bottom left pin to bottom right pin
            ' Vertical position stays the same for this pass
            lLeftPosition = shpIC.Left + shpIC.Width
            lblPin(F).Alignment = vbRightJustify
            lblDirection(F).Alignment = vbLeftJustify
                        
        ElseIf F > nPinsPerSide Then
            ' Up the right side
            lLeftPosition = shpIC.Left + shpIC.Width
            lVerticalPosition = lVerticalPosition - 350
            lblPin(F).Alignment = vbRightJustify
            lblDirection(F).Alignment = vbLeftJustify
        Else
            ' Down the left side
            lLeftPosition = 75
            lVerticalPosition = lVerticalPosition + 350
            lblPin(F).Alignment = vbLeftJustify
            lblDirection(F).Alignment = vbRightJustify
        End If
        
        With lblPin(F)
            .ToolTipText = gtypModel.Pin(F + 1).Tag
            .Top = lVerticalPosition
            .Left = lLeftPosition
            
            sTemp = ""
            If F >= nPinsPerSide Then
                ' Right-hand side
                Select Case gtypModel.Pin(F + 1).Usage
                Case 0 ' Input
                    sTemp = "<--"
                Case 1 ' Output
                    sTemp = "-->"
                Case 2 ' Input/Output
                    sTemp = "<->"
                End Select
                lTagLeftPosition = ((shpIC.Width / 2) + shpIC.Left) - 10
                lblTag(F).Alignment = vbRightJustify
                
            Else
                ' Left-hand side
                Select Case gtypModel.Pin(F + 1).Usage
                Case 0 ' Input
                    sTemp = "-->"
                Case 1 ' Output
                    sTemp = "<--"
                Case 2 ' Input/Output
                    sTemp = "<->"
                End Select
                lTagLeftPosition = shpIC.Left + 90
                lblTag(F).Alignment = vbLeftJustify

            End If
            .Caption = " " & Format$(F + 1) & " "
            .Visible = True
        End With
        
        With lblDirection(F)
            .Caption = " " & sTemp & " "
            .Top = lVerticalPosition
            .Left = lLeftPosition
            .ZOrder 0 ' Make sure it's on the top of the other controls else we don't see it.
            .Visible = True
        End With
        
        With lblTag(F)
            .Top = lVerticalPosition
            .Left = lTagLeftPosition
            .Caption = gtypModel.Pin(F + 1).Tag ' Pin description (short)
            .Visible = True
        End With
        
    Next F
        
    ' Make sure the form is sized correctly
    Me.Height = shpIC.Height + shpIC.Top + 500
    
    Exit Sub
    
ErrorHandler:
    ErrorRoutine Module_Name, PROC_NAME, Err
End Sub



Public Sub UpdateLogicLevels(sLevels As String)

    Dim F                           As Integer
    
    
    For F = 1 To gtypModel.NumPins
        Select Case gtypModel.Pin(F).Usage
        Case 0, 1 ' Pin is an input or output
            lblPin(F - 1).BackColor = glColors(3 + Val(Mid$(sLevels, F, 1)))
        
        End Select
    Next F
    
    
End Sub


Private Sub Form_Load()
    
    gbFormLoaded(2) = True
    RecoverFormLoadPosition Me, True
    
    Call PackagePins
    
End Sub

Private Sub Form_QueryUnload(Cancel As Integer, UnloadMode As Integer)

    gbFormLoaded(2) = False
    ' Save the forms current position
    If Me.WindowState <> vbMinimized Then
        SaveSetting App.Title, "FormPositions", Me.Name, Format$(Me.Width) & "," & Format$(Me.Height) & "," & Format$(Me.Top) & "," & Format$(Me.Left)
    End If
    
    Unload Me
    
End Sub


